// score.c

#include "main.h"
#include "score.h"
#include "gworld.h"
#include "graphics.h"
#include "wdef.h"
#include "blitter.h"
#include "hiscore.h"
#include "gameticks.h"
#include "level.h"

GWorldPtr smallBoardWorld[2], scoreWorld, numberWorld, numberMaskWorld;
Rect scoreWindowZRect, scoreWindowRect[2];
Boolean scoreWindowVisible[2] = {true, true};
long roundStartScore[2], score[2], displayedScore[2], scoreTime[2];
const char characterList[] = 
{ 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',
  'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',
  'U', 'V', 'W', 'X', 'Y', 'Z', '.', '0', '1', '2', 
  '3', '4', '5', '6', '7', '8', '9', '!', '"', '#',
  '$' };

void InitScore( void )
{
	const double windowLoc[ ] = { 0.16, 0.84 };
	Rect myRect;
	
	scoreWindowZRect.top = scoreWindowZRect.left = 0;
	scoreWindowZRect.bottom = 32; scoreWindowZRect.right = 144;
	
	scoreWindowRect[0] = scoreWindowRect[1] = scoreWindowZRect;
	CenterRectInPort( &scoreWindowRect[0], backdropPort, windowLoc[0], 0.89 );
	CenterRectInPort( &scoreWindowRect[1], backdropPort, windowLoc[1], 0.89 );

	InitGWorld( &smallBoardWorld[0], &scoreWindowZRect, 16 );
	DrawPictInGWorld( smallBoardWorld[0], picBoard );

	InitGWorld( &smallBoardWorld[1], &scoreWindowZRect, 16 );
	DrawPictInGWorld( smallBoardWorld[1], picBoard );
	
	InitGWorld( &scoreWorld, &scoreWindowZRect, 16 );
	DrawPictInGWorld( scoreWorld, picBoard );

	myRect.top = myRect.left = 0;
	myRect.bottom = kNumberVertSize;
	myRect.right = kNumberHorizSize * kNumberAmount;
	
	InitGWorld( &numberWorld, &myRect, 16 );
	DrawPictInGWorld( numberWorld, picNumber );
	
	InitGWorld( &numberMaskWorld, &myRect, 1 );
	DrawPictInGWorld( numberMaskWorld, picNumberMask );
	
	displayedScore[0] = displayedScore[1] = 0;
	score[0]          = score[1]          = 0;
	scoreTime[0]      = scoreTime[1]      = 0;
}

void UpdateScore( int player )
{
	if( GameTickCount( ) >= scoreTime[player] )
	{		
		scoreTime[player] = GameTickCount() + 1;
		
		if( displayedScore[player] < score[player] )
		{
			if( (score[player] - displayedScore[player]) > 5000 )
			{
				displayedScore[player] += 1525;
			}
			else if( (score[player] - displayedScore[player]) > 1000 )
			{
				displayedScore[player] += 175;
			}
			else
			{
				displayedScore[player] += 25;
			}
			
			if( displayedScore[player] > score[player] )
				displayedScore[player] = score[player];
			
			ShowScore( player );
		}
	}
}

void ShowScore( int player )
{
	Rect myRect;
	Str255 myString;
	int count;
	
	if( !scoreWindowVisible[player] ) return;
	
	if( control[player] == kNobodyControl )
	{
	}
	else
	{
		NumToString( displayedScore[player], myString );
		
		PrepareForGDrawing( scoreWorld );
		
		CopyBits( GetPortBitMapForCopyBits(smallBoardWorld[player]),
				  GetPortBitMapForCopyBits(scoreWorld),
				  &scoreWindowZRect, &scoreWindowZRect,
				  srcCopy, nil );
		
		myRect.top = 0;
		myRect.left = 2;
		myRect.bottom = kNumberVertSize;
		myRect.right = myRect.left + kNumberHorizSize;
		DrawCharacter( kCharacterScore,   &myRect );
		OffsetRect( &myRect, kNumberHorizSize, 0 );
		DrawCharacter( kCharacterScore+1, &myRect );

		myRect = scoreWindowZRect;
		myRect.right -= 2;
		myRect.left = myRect.right - kNumberHorizSize;
		for( count=myString[0]; count>0; count-- )
		{
			DrawCharacter( myString[count], &myRect );
			OffsetRect( &myRect, -kNumberHorizSize - 1, 0 );
		}
		FinishGDrawing( scoreWorld );
		
		SetPort( backdropPort );
		CopyBits( GetPortBitMapForCopyBits(scoreWorld),
		          GetPortBitMapForCopyBits(backdropPort),
				  &scoreWindowZRect, &scoreWindowRect[player], srcCopy, nil );
	}
}

void DrawCharacter( char which, const Rect *myRect )
{
	Rect srcRect;
	char count, result;
	GrafPtr thePort;
	
	result = -1;
	for( count = 0; count<kNumberAmount; count++ )
	{
		if( characterList[count] == which ) result = count;
	}
	
	if( result == -1 ) return;
	
	srcRect.top = 0;
	srcRect.left = result * kNumberHorizSize;
	srcRect.bottom = kNumberVertSize;
	srcRect.right = srcRect.left + kNumberHorizSize;
	
	GetPort( &thePort );
	CopyMask( GetPortBitMapForCopyBits(numberWorld),
				GetPortBitMapForCopyBits(numberMaskWorld),
				  GetPortBitMapForCopyBits(thePort),
			  &srcRect,
			    &srcRect,
			      myRect );
}
